<?php $__env->startSection('title', __('repair::lang.add_repair')); ?>

<?php $__env->startSection('content'); ?>
<style type="text/css">
	.krajee-default.file-preview-frame .kv-file-content {
		height: 65px;
	}
</style>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/patternlock/patternlock.min.css')); ?>">

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('repair::lang.add_repair')); ?></h1>
</section>
<!-- Main content -->
<section class="content no-print">
<?php if(is_null($default_location)): ?>
<div class="row">
	<div class="col-sm-3">
		<div class="form-group">
			<div class="input-group">
				<span class="input-group-addon">
					<i class="fa fa-map-marker"></i>
				</span>
			<?php echo Form::select('select_location_id', $business_locations, null, ['class' => 'form-control input-sm', 
			'placeholder' => __('lang_v1.select_location'),
			'id' => 'select_location_id', 
			'required', 'autofocus'], $bl_attributes);; ?>

			<span class="input-group-addon">
					<?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.sale_location') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
				</span> 
			</div>
		</div>
	</div>
</div>
<?php endif; ?>
<input type="hidden" id="item_addition_method" value="<?php echo e($business_details->item_addition_method); ?>">

<?php if(!empty($repair_settings['default_product'])): ?>
 	<input type="hidden" id="default_product" value="<?php echo e($repair_settings['default_product']); ?>">
<?php endif; ?>

	<?php echo Form::open(['url' => action('SellPosController@store'), 'method' => 'post', 'id' => 'add_sell_form', 'files' => true ]); ?>

	<?php echo Form::hidden('status', 'final');; ?>

	<?php echo Form::hidden('sub_type', 'repair');; ?>

	<?php echo Form::hidden('has_module_data', true);; ?>

	<div class="row">
		<div class="col-md-12 col-sm-12">
			<?php $__env->startComponent('components.widget'); ?>
				<?php echo Form::hidden('location_id', $default_location, ['id' => 'location_id', 'data-receipt_printer_type' => isset($bl_attributes[$default_location]['data-receipt_printer_type']) ? $bl_attributes[$default_location]['data-receipt_printer_type'] : 'browser']);; ?>

				
				<div class="clearfix"></div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('contact_id', __('contact.customer') . ':*'); ?>

						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-user"></i>
							</span>
							<input type="hidden" id="default_customer_id" 
							value="<?php echo e($walk_in_customer['id']); ?>" >
							<input type="hidden" id="default_customer_name" 
							value="<?php echo e($walk_in_customer['name']); ?>" >
							<?php echo Form::select('contact_id', 
								[], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']);; ?>

							<span class="input-group-btn">
								<button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
							</span>
						</div>
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('transaction_date', __('repair::lang.repair_added_on') . ':*'); ?>

						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
							<?php echo Form::text('transaction_date', $default_datetime, ['class' => 'form-control', 'readonly', 'required']);; ?>

						</div>
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('repair_completed_on', __('repair::lang.repair_completed_on') . ':*'); ?>

						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
							<?php echo Form::text('repair_completed_on', $default_datetime, ['class' => 'form-control', 'readonly', 'required']);; ?>

						</div>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="col-sm-4">
					<div class="form-group">
						<label for="repair_status_id"><?php echo e(__('repair::lang.repair_status') . ':*'); ?></label>
						<select name="repair_status_id" class="form-control" id="repair_status_id" required></select>
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('repair_warranty_id', __('repair::lang.repair_warranty') . ':'); ?>

						<?php echo Form::select('repair_warranty_id', $warranties, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select')]);; ?>

					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('repair_brand_id', __('repair::lang.manufacturer') . ':'); ?>

						<?php echo Form::select('repair_brand_id', $brands, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select')]);; ?>

					</div>
				</div>
				<div class="clearfix"></div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('repair_model', __('repair::lang.model') . ':'); ?>

						<?php echo Form::text('repair_model', null, ['class' => 'form-control', 'placeholder' => __('repair::lang.model')]);; ?>

					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
						<?php echo Form::label('repair_serial_no', __('repair::lang.serial_no') . ':'); ?>

						<?php echo Form::text('repair_serial_no', null, ['class' => 'form-control', 'placeholder' => __('repair::lang.serial_no')]);; ?>

					</div>
				</div>
				<?php if(in_array('service_staff' ,$enabled_modules)): ?>
					<div class="col-sm-4">
						<div class="form-group">
							<?php echo Form::label('res_waiter_id', __('repair::lang.assign_repair_to') . ':'); ?>

							<?php echo Form::select('res_waiter_id', $service_staff, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select')]);; ?>

						</div>
					</div>
				<?php endif; ?>
				<div class="clearfix"></div>
				<div class="col-sm-4">
					<br>
					<div class="checkbox">
						<label>
						<?php echo Form::checkbox('repair_updates_email', 1, false, ['class' => 'input-icheck']);; ?> <?php echo e(app('translator')->getFromJson('repair::lang.auto_send_notification')); ?> (Email)
						</label> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.auto_send_email_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
					</div>
				</div>
				<div class="col-sm-4">
					<br>
					<div class="checkbox">
						<label>
						<?php echo Form::checkbox('repair_updates_sms', 1, false, ['class' => 'input-icheck']);; ?> <?php echo e(app('translator')->getFromJson('repair::lang.auto_send_notification')); ?> (SMS)
						</label> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('repair::lang.auto_send_sms_tooltip') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="col-sm-2">
					<div class="form-group">
					<br>
						<button type="button" class="btn btn-primary btn-flat" data-toggle="modal" data-target="#checklist_modal"><i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson('repair::lang.pre_repair_checklist')); ?></button>
					</div>
				</div>
				<div class="col-sm-2">
					<div class="form-group">
						<br>
						<button type="button" class="btn btn-primary btn-flat" data-toggle="modal" data-target="#security_modal"><i class="fa fa-lock"></i> <?php echo e(app('translator')->getFromJson('repair::lang.security')); ?></button>
					</div>
				</div>
				<div class="clearfix"></div>
			    <div class="col-md-12">
			        <div class="form-group">
			            <?php echo Form::label('documents', __('lang_v1.upload_documents') . ':' ); ?>

			            <?php echo Form::file('documents[]', ['multiple', 'id' => 'documents']);; ?>

			        </div>
			    </div>
				<?php echo $__env->make('repair::repair.partials.security_modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				<?php echo $__env->make('repair::repair.partials.checklist_modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			<?php echo $__env->renderComponent(); ?>

			<?php $__env->startComponent('components.widget'); ?>
				<div class="col-sm-6">
					<div class="form-group">
						<?php echo Form::label('repair_defects',__('repair::lang.defect') . ':'); ?>

						<?php echo Form::textarea('repair_defects', null, ['class' => 'form-control', 'rows' => 3]);; ?>

					</div>
				</div>
				<div class="col-sm-6">
					<div class="form-group">
						<?php echo Form::label('staff_note',__('repair::lang.noted_problems_n_technician_comments'). ':'); ?>

						<?php echo Form::textarea('staff_note', null, ['class' => 'form-control', 'rows' => 3]);; ?>

					</div>
				</div>
			<?php echo $__env->renderComponent(); ?>

			<?php $__env->startComponent('components.widget'); ?>
				<div class="col-sm-10 col-sm-offset-1">
					<div class="form-group">
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-barcode"></i>
							</span>
							<?php echo Form::text('search_product', null, ['class' => 'form-control mousetrap', 'id' => 'search_product', 'placeholder' => __('repair::lang.add_parts_used_in_repair'),
							'disabled' => is_null($default_location)? true : false,
							'autofocus' => is_null($default_location)? false : true,
							]);; ?>

						</div>
					</div>
				</div>

				<div class="row col-sm-12 pos_product_div" style="min-height: 0">

					<input type="hidden" name="sell_price_tax" id="sell_price_tax" value="<?php echo e($business_details->sell_price_tax); ?>">

					<!-- Keeps count of product rows -->
					<input type="hidden" id="product_row_count" 
						value="0">
					<?php
						$hide_tax = '';
						if( session()->get('business.enable_inline_tax') == 0){
							$hide_tax = 'hide';
						}
					?>
					<div class="table-responsive">
					<table class="table table-condensed table-bordered table-striped table-responsive" id="pos_table">
						<thead>
							<tr>
								<th class="text-center">	
									<?php echo e(app('translator')->getFromJson('sale.product')); ?>
								</th>
								<th class="text-center">
									<?php echo e(app('translator')->getFromJson('sale.qty')); ?>
								</th>
								<?php if(!empty($pos_settings['inline_service_staff']) && in_array('service_staff' ,$enabled_modules)): ?>
									<th class="text-center col-md-2">
										<?php echo e(app('translator')->getFromJson('restaurant.service_staff')); ?>
									</th>
								<?php endif; ?>
								<th class="text-center <?php echo e($hide_tax); ?>">
									<?php echo e(app('translator')->getFromJson('sale.price_inc_tax')); ?>
								</th>
								<th class="text-center">
									<?php echo e(app('translator')->getFromJson('sale.subtotal')); ?>
								</th>
								<th class="text-center"><i class="fa fa-close" aria-hidden="true"></i></th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
					</div>
					<div class="table-responsive">
					<table class="table table-condensed table-bordered table-striped">
						<tr>
							<td>
								<div class="pull-right"><b><?php echo e(app('translator')->getFromJson('sale.total')); ?>: </b>
									<span class="price_total">0</span>
								</div>
							</td>
						</tr>
					</table>
					</div>
				</div>
			<?php echo $__env->renderComponent(); ?>

			<?php $__env->startComponent('components.widget'); ?>
				<div class="col-md-4">
			        <div class="form-group">
			            <?php echo Form::label('discount_type', __('sale.discount_type') . ':*' ); ?>

			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                <?php echo Form::select('discount_type', ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], 'percentage' , ['class' => 'form-control','placeholder' => __('messages.please_select'), 'required', 'data-default' => 'percentage']);; ?>

			            </div>
			        </div>
			    </div>
			    <div class="col-md-4">
			        <div class="form-group">
			            <?php echo Form::label('discount_amount', __('sale.discount_amount') . ':*' ); ?>

			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                <?php echo Form::text('discount_amount', number_format($business_details->default_sales_discount, config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control input_number', 'data-default' => $business_details->default_sales_discount]);; ?>

			            </div>
			        </div>
			    </div>
			    <div class="col-md-4"><br>
			    	<b><?php echo e(app('translator')->getFromJson( 'sale.discount_amount' )); ?>:</b>(-) 
					<span class="display_currency" id="total_discount">0</span>
			    </div>
			    <div class="clearfix"></div>
			    <div class="col-md-4">
			    	<div class="form-group">
			            <?php echo Form::label('tax_rate_id', __('sale.order_tax') . ':*' ); ?>

			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                <?php echo Form::select('tax_rate_id', $taxes['tax_rates'], $business_details->default_sales_tax, ['placeholder' => __('messages.please_select'), 'class' => 'form-control', 'data-default'=> $business_details->default_sales_tax], $taxes['attributes']);; ?>


							<input type="hidden" name="tax_calculation_amount" id="tax_calculation_amount" 
							value="<?php if(empty($edit)): ?> <?php echo e(number_format($business_details->tax_calculation_amount, config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?> <?php else: ?> <?php echo e(number_format(optional($transaction->tax)->amount, config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?> <?php endif; ?>" data-default="<?php echo e($business_details->tax_calculation_amount); ?>">
			            </div>
			        </div>
			    </div>
			    <div class="col-md-4 col-md-offset-4">
			    	<b><?php echo e(app('translator')->getFromJson( 'sale.order_tax' )); ?>:</b>(+) 
					<span class="display_currency" id="order_tax">0</span>
			    </div>
			    <div class="clearfix"></div>
				<div class="col-md-4">
					<div class="form-group">
			            <?php echo Form::label('shipping_details', __('sale.shipping_details')); ?>

			            <div class="input-group">
							<span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                <?php echo Form::textarea('shipping_details',null, ['class' => 'form-control','placeholder' => __('sale.shipping_details') ,'rows' => '1', 'cols'=>'30']);; ?>

			            </div>
			        </div>
				</div>
				<div class="col-md-4">
					<div class="form-group">
						<?php echo Form::label('shipping_charges', __('sale.shipping_charges')); ?>

						<div class="input-group">
						<span class="input-group-addon">
						<i class="fa fa-info"></i>
						</span>
						<?php echo Form::text('shipping_charges',number_format(0.00, config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']),['class'=>'form-control input_number','placeholder'=> __('sale.shipping_charges')]);; ?>

						</div>
					</div>
				</div>
			    <div class="clearfix"></div>
			    <div class="col-md-4 col-md-offset-8">
			    	<div><b><?php echo e(app('translator')->getFromJson('sale.total_payable')); ?>: </b>
						<input type="hidden" name="final_total" id="final_total_input">
						<span id="total_payable">0</span>
					</div>
			    </div>
				<input type="hidden" name="is_direct_sale" value="1">
				<input type="hidden" id="print_label" name="print_label" value="0">
				<div class="clearfix"></div>
				<div class="col-md-12">
					<button type="button" id="submit-sell" class="btn btn-primary pull-right btn-flat"><?php echo e(app('translator')->getFromJson('messages.submit')); ?></button>
					<button type="button" id="submit-n-print-label" class="btn btn-danger pull-right btn-flat" style="margin-right: 10px;"><?php echo e(app('translator')->getFromJson('repair::lang.submit_n_print_label')); ?></button>
				</div>
			<?php echo $__env->renderComponent(); ?>

		</div>
	</div>
	
	<?php echo Form::close(); ?>

</section>

<div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
	<?php echo $__env->make('contact.create', ['quick_add' => true], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<!-- /.content -->
<div class="modal fade register_details_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade close_register_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
	<script src="<?php echo e(asset('js/pos.js?v=' . $asset_v)); ?>"></script>
	<script src="<?php echo e(asset('plugins/patternlock/patternlock.min.js')); ?>"></script>
	<?php echo $__env->make('repair::layouts.partials.javascripts', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<script type="text/javascript">
		$(document).ready( function() {
			<?php echo $__env->make('repair::repair.partials.repair_status', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			if($('input#default_product').length) {
				pos_product_row($('input#default_product').val());
			}

			$('#submit-n-print-label').click( function() {
				$('input#print_label').val(1);
				$("#submit-sell").trigger('click');
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>